<?php
namespace lib\field;

class Select extends \lib\Field
{
	public $type = 'select';
	private $options;
	
	public function __construct($name, $options=array(), $value='', $validation=array(), $assoc=true)
	{
		$this->name = $name;
		$this->value = $value;
		$this->options = array();
		$this->validation = $validation;
		
		foreach($options as $key=>$value)
		{
			if(is_int($key) && $assoc !== false)
			{
				if($response = \lib\Lang::get($value))
				{
					$key = $value;
					$value = $response;
				} else
				{
					$key = $value;
				}
			}
			
			$this->options[$key] = $value;
		}
	}
	
	public function validate()
	{
		if(!isset($this->options[$this->value]))
		{
			return $this->set_error('optional');
		}
		
		return parent::validate();
	}
	
	public function input()
	{
		$field = '<select name="'.$this->name.'['.$this->form->bulk.']">';
		
		foreach($this->options as $key=>$value)
		{
			if($key == $this->value)
			{
				$field .= '<option value="'.$key.'" selected>'.$value.'</option>';
			} else
			{
				$field .= '<option value="'.$key.'">'.$value.'</option>';
			}
		}
		
		$field .= '</select>';
		
		return $field;
	}
}